-- Base  copier
USE [maBase];
GO

-- Variables locales
DECLARE @DATABASE sysname,
        @SQL NVARCHAR(max),
        @PATH NVARCHAR(256);

-- Rpertoire de copie des fichiers
SET @PATH = 'C:\SAUVEGARDE\DATABASE\FILES\'

-- Table temporaire des fichiers de la base
CREATE TABLE #T_FILES
(name            sysname,
 physical_name   NVARCHAR(260),
 type_desc       NVARCHAR(60));

-- Rcupration des mtadonnes des fichiers de la base
INSERT INTO #T_FILES (name, physical_name, type_desc)
SELECT name, physical_name, type_desc
FROM   sys.database_files;
SET @DATABASE = DB_NAME();

-- Prparation  la copie des fichiers avec dconnexion imprative des utilisateurs et dtachement des fichiers de la base
SET @SQL = 'ALTER DATABASE [' +@DATABASE +'] SET SINGLE_USER WITH ROLLBACK IMMEDIATE;USE master;EXEC sp_detach_db ''' + @DATABASE +''';'

-- Copie des fichiers de la base
SELECT @SQL = @SQL + 'EXEC xp_cmdshell ''COPY "' + physical_name + '", "' + @PATH +'"'';'
FROM #T_FILES;

-- Recration de la base par attachement
SET @SQL = @SQL + 'CREATE DATABASE [' + @DATABASE +'] ON ('

-- Prcision des fichiers de donnes transactionnelles
SELECT @SQL =@SQL + 'NAME = ''' + name + ''', FILENAME = ''' + physical_name +''','
FROM   #T_FILES
WHERE  type_desc = 'ROWS';

-- Ajout du journal
SET @SQL = SUBSTRING(@SQL, 1, LEN(@SQL) - 1) + ') LOG ON ('

-- Prcision des fichiers de donnes du journal
SELECT @SQL =@SQL + 'NAME = ''' + name + ''', FILENAME = ''' + physical_name +''','
FROM   #T_FILES
WHERE  type_desc = 'LOG';

SET @SQL = SUBSTRING(@SQL, 1, LEN(@SQL) - 1) + ') FOR ATTACH;'

-- Suppression de la table temporaire
DROP TABLE #T_FILES ;

-- Visualisation du rsultat
PRINT @SQL

-- Excution
EXEC (@SQL);

--> ATTENTION : une table "##T_FILE" a t indique par erreur dans le script de la version imprime,  la ligne "INSERT INTO". Il fallait lire "#T_FILES"
